﻿//////////////////////////////////////////////
// DxDefinesWrapper.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Enums ------------------------------------
	
namespace nkGraphics
{
	// DXGI_FORMAT
	enum FORMAT
	{
		UNKNOWN_FORMAT				= 0,
		R32G32B32A32_TYPELESS		= 1,
		R32G32B32A32_FLOAT			= 2,
		R32G32B32A32_UINT			= 3,
		R32G32B32A32_SINT			= 4,
		R32G32B32_TYPELESS			= 5,
		R32G32B32_FLOAT				= 6,
		R32G32B32_UINT				= 7,
		R32G32B32_SINT				= 8,
		R16G16B16A16_TYPELESS		= 9,
		R16G16B16A16_FLOAT			= 10,
		R16G16B16A16_UNORM			= 11,
		R16G16B16A16_UINT			= 12,
		R16G16B16A16_SNORM			= 13,
		R16G16B16A16_SINT			= 14,
		R32G32_TYPELESS				= 15,
		R32G32_FLOAT				= 16,
		R32G32_UINT					= 17,
		R32G32_SINT					= 18,
		R32G8X24_TYPELESS			= 19,
		D32_FLOAT_S8X24_UINT		= 20,
		R32_FLOAT_X8X24_TYPELESS	= 21,
		X32_TYPELESS_G8X24_UINT		= 22,
		R10G10B10A2_TYPELESS		= 23,
		R10G10B10A2_UNORM			= 24,
		R10G10B10A2_UINT			= 25,
		R11G11B10_FLOAT				= 26,
		R8G8B8A8_TYPELESS			= 27,
		R8G8B8A8_UNORM				= 28,
		R8G8B8A8_UNORM_SRGB			= 29,
		R8G8B8A8_UINT				= 30,
		R8G8B8A8_SNORM				= 31,
		R8G8B8A8_SINT				= 32,
		R16G16_TYPELESS				= 33,
		R16G16_FLOAT				= 34,
		R16G16_UNORM				= 35,
		R16G16_UINT					= 36,
		R16G16_SNORM				= 37,
		R16G16_SINT					= 38,
		R32_TYPELESS				= 39,
		D32_FLOAT					= 40,
		R32_FLOAT					= 41,
		R32_UINT					= 42,
		R32_SINT					= 43,
		R24G8_TYPELESS				= 44,
		D24_UNORM_S8_UINT			= 45,
		R24_UNORM_X8_TYPELESS		= 46,
		X24_TYPELESS_G8_UINT		= 47,
		R8G8_TYPELESS				= 48,
		R8G8_UNORM					= 49,
		R8G8_UINT					= 50,
		R8G8_SNORM					= 51,
		R8G8_SINT					= 52,
		R16_TYPELESS				= 53,
		R16_FLOAT					= 54,
		D16_UNORM					= 55,
		R16_UNORM					= 56,
		R16_UINT					= 57,
		R16_SNORM					= 58,
		R16_SINT					= 59,
		R8_TYPELESS					= 60,
		R8_UNORM					= 61,
		R8_UINT						= 62,
		R8_SNORM					= 63,
		R8_SINT						= 64,
		A8_UNORM					= 65,
		R1_UNORM					= 66,
		R9G9B9E5_SHAREDEXP			= 67,
		R8G8_B8G8_UNORM				= 68,
		G8R8_G8B8_UNORM				= 69,
		BC1_TYPELESS				= 70,
		BC1_UNORM					= 71,
		BC1_UNORM_SRGB				= 72,
		BC2_TYPELESS				= 73,
		BC2_UNORM					= 74,
		BC2_UNORM_SRGB				= 75,
		BC3_TYPELESS				= 76,
		BC3_UNORM					= 77,
		BC3_UNORM_SRGB				= 78,
		BC4_TYPELESS				= 79,
		BC4_UNORM					= 80,
		BC4_SNORM					= 81,
		BC5_TYPELESS				= 82,
		BC5_UNORM					= 83,
		BC5_SNORM					= 84,
		B5G6R5_UNORM				= 85,
		B5G5R5A1_UNORM				= 86,
		B8G8R8A8_UNORM				= 87,
		B8G8R8X8_UNORM				= 88,
		FORCE_UINT					= 0xffffffffUL,
	} ;

	// D3D11_MAP
	enum MAP
	{
		MAP_READ                = 1,
		MAP_WRITE               = 2,
		MAP_READ_WRITE          = 3,
		MAP_WRITE_DISCARD       = 4,
		MAP_WRITE_NO_OVERWRITE  = 5
	} ;

	// D3D11_DEPTH_WRITE_MASK
	enum DEPTH_WRITE_MASK
	{
		DEPTH_WRITE_MASK_ZERO  = 0,
		DEPTH_WRITE_MASK_ALL   = 1
	} ;

	// D3D11_STENCIL_OP
	enum STENCIL_OP
	{
		STENCIL_OP_KEEP      = 1,
		STENCIL_OP_ZERO      = 2,
		STENCIL_OP_REPLACE   = 3,
		STENCIL_OP_INCR_SAT  = 4,
		STENCIL_OP_DECR_SAT  = 5,
		STENCIL_OP_INVERT    = 6,
		STENCIL_OP_INCR      = 7,
		STENCIL_OP_DECR      = 8
	} ;

	// D3D11_DSV_FLAG
	enum DSV_FLAG
	{
		DSV_READ_ONLY_DEPTH    = 0x1L,
		DSV_READ_ONLY_STENCIL  = 0x2L
	} ;

	// D3D11_DSV_DIMENSION
	enum DSV_DIMENSION
	{
		DSV_DIMENSION_UNKNOWN           = 0,
		DSV_DIMENSION_TEXTURE1D         = 1,
		DSV_DIMENSION_TEXTURE1DARRAY    = 2,
		DSV_DIMENSION_TEXTURE2D         = 3,
		DSV_DIMENSION_TEXTURE2DARRAY    = 4,
		DSV_DIMENSION_TEXTURE2DMS       = 5,
		DSV_DIMENSION_TEXTURE2DMSARRAY  = 6
	} ;

	// D3D11_RTV_DIMENSION
	enum RTV_DIMENSION
	{
		RTV_DIMENSION_UNKNOWN           = 0,
		RTV_DIMENSION_BUFFER            = 1,
		RTV_DIMENSION_TEXTURE1D         = 2,
		RTV_DIMENSION_TEXTURE1DARRAY    = 3,
		RTV_DIMENSION_TEXTURE2D         = 4,
		RTV_DIMENSION_TEXTURE2DARRAY    = 5,
		RTV_DIMENSION_TEXTURE2DMS       = 6,
		RTV_DIMENSION_TEXTURE2DMSARRAY  = 7,
		RTV_DIMENSION_TEXTURE3D         = 8
	} ;

	// D3D11_SRV_DIMENSION
	enum SRV_DIMENSION
	{
		SRV_DIMENSION_UNKNOWN           = 0,
		SRV_DIMENSION_BUFFER            = 1,
		SRV_DIMENSION_TEXTURE1D         = 2,
		SRV_DIMENSION_TEXTURE1DARRAY    = 3,
		SRV_DIMENSION_TEXTURE2D         = 4,
		SRV_DIMENSION_TEXTURE2DARRAY    = 5,
		SRV_DIMENSION_TEXTURE2DMS       = 6,
		SRV_DIMENSION_TEXTURE2DMSARRAY  = 7,
		SRV_DIMENSION_TEXTURE3D         = 8,
		SRV_DIMENSION_TEXTURECUBE       = 9,
		SRV_DIMENSION_TEXTURECUBEARRAY  = 10,
		SRV_DIMENSION_BUFFEREX          = 11
	} ;

	// D3D11_UAV_DIMENSION
	enum UAV_DIMENSION
	{
		UAV_DIMENSION_UNKNOWN         = 0,
		UAV_DIMENSION_BUFFER          = 1,
		UAV_DIMENSION_TEXTURE1D       = 2,
		UAV_DIMENSION_TEXTURE1DARRAY  = 3,
		UAV_DIMENSION_TEXTURE2D       = 4,
		UAV_DIMENSION_TEXTURE2DARRAY  = 5,
		UAV_DIMENSION_TEXTURE3D       = 8
	} ;

	// D3D11_BUFFEREX_SRV_FLAG
	enum BUFFEREX_SRV_FLAG
	{
		BUFFEREX_SRV_FLAG_RAW  = 0x1
	} ;

	// D3D11_BUFFER_UAV_FLAG
	enum BUFFER_UAV_FLAG
	{
		BUFFER_UAV_FLAG_RAW      = 0x1,
		BUFFER_UAV_FLAG_APPEND   = 0x2,
		BUFFER_UAV_FLAG_COUNTER  = 0x4
	} ;

	// D3D11_BLEND
	enum BLEND
	{
		BLEND_ZERO              = 1,
		BLEND_ONE               = 2,
		BLEND_SRC_COLOR         = 3,
		BLEND_INV_SRC_COLOR     = 4,
		BLEND_SRC_ALPHA         = 5,
		BLEND_INV_SRC_ALPHA     = 6,
		BLEND_DEST_ALPHA        = 7,
		BLEND_INV_DEST_ALPHA    = 8,
		BLEND_DEST_COLOR        = 9,
		BLEND_INV_DEST_COLOR    = 10,
		BLEND_SRC_ALPHA_SAT     = 11,
		BLEND_BLEND_FACTOR      = 14,
		BLEND_INV_BLEND_FACTOR  = 15,
		BLEND_SRC1_COLOR        = 16,
		BLEND_INV_SRC1_COLOR    = 17,
		BLEND_SRC1_ALPHA        = 18,
		BLEND_INV_SRC1_ALPHA    = 19
	} ;

	// D3D11_BLEND_OP
	enum BLEND_OP
	{
		BLEND_OP_ADD           = 1,
		BLEND_OP_SUBTRACT      = 2,
		BLEND_OP_REV_SUBTRACT  = 3,
		BLEND_OP_MIN           = 4,
		BLEND_OP_MAX           = 5
	} ;

	// D3D11_COLOR_WRITE_ENABLE 
	enum COLOR_WRITE_ENABLE
	{
		COLOR_WRITE_ENABLE_RED		= 1,
		COLOR_WRITE_ENABLE_GREEN	= 2,
		COLOR_WRITE_ENABLE_BLUE		= 4,
		COLOR_WRITE_ENABLE_ALPHA	= 8,
		COLOR_WRITE_ENABLE_ALL		= (((COLOR_WRITE_ENABLE_RED | COLOR_WRITE_ENABLE_GREEN) | COLOR_WRITE_ENABLE_BLUE) | COLOR_WRITE_ENABLE_ALPHA)
	} ;

	// D3D11_FILL_MODE
	enum FILL_MODE
	{
		FILL_WIREFRAME = 2,
		FILL_SOLID = 3
	} ;

	// D3D11_CULL_MODE
	enum CULL_MODE
	{
		CULL_NONE = 1,
		CULL_FRONT = 2,
		CULL_BACK = 3
	} ;

	// Custom enum : type de shader concerne
	enum SHADER_TYPE
	{
		VERTEX_SHADER = 0,
		HULL_SHADER,
		DOMAIN_SHADER,
		GEOMETRY_SHADER,
		PIXEL_SHADER,
		COMPUTE_SHADER,
		RAYTRACING_SHADER,
		UNKNOWN_SHADER
	} ;

	// Custom enum : les semantiques
	enum SHADER_SEMANTIC
	{
		// Per vertex
		POSITION_0 = 0,
		POSITION_1,
		POSITION_2,
		POSITION_3,
		POSITION_4,
		NORMAL_0 = POSITION_0 + 8,
		NORMAL_1,
		NORMAL_2,
		NORMAL_3,
		NORMAL_4,
		UV_0 = NORMAL_0 + 8,
		UV_1,
		UV_2,
		UV_3,
		UV_4,
		COLOR_0 = UV_0 + 8,
		COLOR_1,
		COLOR_2,
		COLOR_3,
		COLOR_4,
		TANGENT_0 = COLOR_0 + 8,
		TANGENT_1,
		TANGENT_2,
		TANGENT_3,
		TANGENT_4,
		BINORMAL_0 = TANGENT_0 + 8,
		BINORMAL_1,
		BINORMAL_2,
		BINORMAL_3,
		BINORMAL_4,
		// Vertex data
		SV_VERTEX_ID = BINORMAL_0 + 8,
		// Instance
		WORLDMAT_0 = SV_VERTEX_ID + 1,
		WORLDMAT_1,
		WORLDMAT_2,
		WORLDMAT_3,
		WORLDMAT_INV_TRANSPOSE_0 = WORLDMAT_3 + 1,
		WORLDMAT_INV_TRANSPOSE_1,
		WORLDMAT_INV_TRANSPOSE_2,
		WORLDMAT_INV_TRANSPOSE_3,
		// Offset pour les output semantics
		OUTPUT_SEMANTIC_OFFSET = WORLDMAT_0 + 16,
		// Maximum bound
		MAXIMUM_SEMANTIC_INDEX = OUTPUT_SEMANTIC_OFFSET * 2
	} ;

	enum SHADER_RESOURCE_SLOT
	{
		// Constant buffer
		CONSTANT_BUFFER_0 = 0,
		CONSTANT_BUFFER_1,
		CONSTANT_BUFFER_2,
		CONSTANT_BUFFER_3,
		CONSTANT_BUFFER_4,
		CONSTANT_BUFFER_5,
		CONSTANT_BUFFER_6,
		CONSTANT_BUFFER_7,
		CONSTANT_BUFFER_8,
		CONSTANT_BUFFER_9,
		CONSTANT_BUFFER_10,
		CONSTANT_BUFFER_11,
		CONSTANT_BUFFER_12,
		CONSTANT_BUFFER_13,
		CONSTANT_BUFFER_14,
		CONSTANT_BUFFER_15,
		CONSTANT_BUFFER_16,
		CONSTANT_BUFFER_17,
		CONSTANT_BUFFER_18,
		// Shader resource
		SHADER_RESOURCE_0,
		SHADER_RESOURCE_1,
		SHADER_RESOURCE_2,
		SHADER_RESOURCE_3,
		SHADER_RESOURCE_4,
		SHADER_RESOURCE_5,
		SHADER_RESOURCE_6,
		SHADER_RESOURCE_7,
		SHADER_RESOURCE_8,
		SHADER_RESOURCE_9,
		SHADER_RESOURCE_10,
		SHADER_RESOURCE_11,
		SHADER_RESOURCE_12,
		SHADER_RESOURCE_13,
		SHADER_RESOURCE_14,
		SHADER_RESOURCE_15,
		SHADER_RESOURCE_16,
		SHADER_RESOURCE_17,
		SHADER_RESOURCE_18,
		// UAV
		UAV_RESOURCE_0,
		UAV_RESOURCE_1,
		UAV_RESOURCE_2,
		UAV_RESOURCE_3,
		UAV_RESOURCE_4,
		UAV_RESOURCE_5,
		UAV_RESOURCE_6,
		UAV_RESOURCE_7,
		UAV_RESOURCE_8,
		UAV_RESOURCE_9,
		UAV_RESOURCE_10,
		UAV_RESOURCE_11,
		UAV_RESOURCE_12,
		UAV_RESOURCE_13,
		UAV_RESOURCE_14,
		UAV_RESOURCE_15,
		UAV_RESOURCE_16,
		UAV_RESOURCE_17,
		UAV_RESOURCE_18,
		// Sampler
		SAMPLER_0,
		SAMPLER_1,
		SAMPLER_2,
		SAMPLER_3,
		SAMPLER_4,
		SAMPLER_5,
		SAMPLER_6
	} ;

	enum PROGRAM_COMPILATION_PROFILE
	{
		PROFILE_UNKNOWN = 0,
		PROFILE_SM_5_0,
		PROFILE_SM_5_1,
		PROFILE_SM_6_0
	} ;
}